﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class Camera2 : MonoBehaviour
{
    
    public Transform Car;
    public Vector3 CarRotEuler; 
    
    // Start is called before the first frame update
    void Start()
    {

    }

    // Update is called once per frame
    void FixUpdate()
    {
        
        CarRotEuler = Car.rotation.eulerAngles;
        transform.eulerAngles = new Vector3(0, CarRotEuler.y, 0);

        var V1 = transform.TransformDirection(new Vector3(0, -1, +1).normalized);

        RaycastHit hit;
        if (Physics.Raycast(transform.position, V1, out hit))
        {
            var V2 = hit.point - transform.position;
            var k = Vector3.Dot(V1, V2);
            if (k < 2.5)
                transform.position -= k * V1;
        }
    }
}
